//****************************************************************************************************************
//Struktura do ktere se ulozi adresa navesti
//****************************************************************************************************************
struct LABEL_ADRESSES
{
	char*			unique_labelname;			//unikatni identifikator, jmeno navesti
	unsigned int	label_offset;				//offset navesti

	bool			operator == (char* right)		//operator pro porovnani
	{
		return (strcmp(unique_labelname,right) == 0) ? true : false;
	}
};
//****************************************************************************************************************
//trida predstavujici seznam adres navesti
//****************************************************************************************************************
class CLabelsList
{
private:
	std::vector<LABEL_ADRESSES*>			m_List;
public:
	HRESULT									AddLabel(char* uniquename,int iOffset);
	LABEL_ADRESSES*							GetLabel(char* uniquename);
	int										GetLabelAdress(char* uniquename);
	int										Contains(char* uniquename);

	unsigned int							Size();
	LABEL_ADRESSES*							operator [] (unsigned int index);

	~CLabelsList();
};
//****************************************************************************************************************
//Assembler modul. Prevede assembly formu skriptu do binarniho souboru
//****************************************************************************************************************
class CAssembler
{
private:
	unsigned char*			m_pByteCode;			//bytovy kodovy segment
	unsigned int			m_iCurrMult;			//soucasny nasobek velikosti pole
	unsigned int			m_iCurrPositionInCode;	//soucasna pozice v bytovem kodovem segmentu

	FILE*					m_binFile;				//soubor do ktereho zapiseme program
	FILE*					m_inputFile;			//vstupni soubor, obsahujici assembly programu

	char*					m_CurrFuncName;			//soucasne jmeno funkce, jmeno funkce ktera se zrovna zpracovava

	CConstantTable			m_Constants;			//tabulka konstant
	CLabelsList				m_LabelsHoles;			//tabulka mist kde maji byt navesti
	CLabelsList				m_LabelsPositions;		//tabulka s adresami navesti
private:
	void					AddCode(unsigned char code);
	void					CheckCodeSize(int nBytes);
	void					processCode(char* token);
	void					WriteCodeSegment();
	void					WriteConstants();
	void					processFUNCTION();
	void					processIMPORT();
	void					processHoles();

	void					AddIndex16(unsigned short index);
	void					AddIndex32(unsigned int index);
	void inline				AddHoleForLabel();
public:
	void					Process(char* pFile);

	CAssembler();
	~CAssembler();
};